import QtQuick 2.1
import QtQuick.Controls 1.3
import QtQuick.Controls.Styles 1.3
import MuseScore 3.0

MuseScore {
      version: "1.0"
      description: "Retune selection to 27ED4 nelindic"
      menuPath: "Plugins.27ED4.Tune"
      pluginType: "dialog"
      width: 320
      height: 240

      // WARNING! This doesn't validate the accidental code!
      property variant customKeySigRegex: /\.(.*)\.(.*)\.(.*)\.(.*)\.(.*)\.(.*)\.(.*)/g

      property variant centOffsets: {
      'od3': {
        'a': {
          '-2': 200 - 2 * 2400/27 - 2400, // Abb correction
          '-1': 100 - 1 * 2400/27 - 2400, // Ab correction
           0: 0 - 3600,         // A
           1: 1 * 2400/27 - 100 - 3600,   // A#
           2: 2 * 2400/27 - 200 - 3600    // Ax
        },
        'b': {
              '-2': 2 * 2400/27 - 3600, // Bbb
              '-1': 3 * 2400/27 - 100 - 3600, // Bb
               0: 4 * 2400/27 - 200 - 3600,         // B
               1: 5 * 2400/27 - 300 - 3600,   // B#
               2: 6 * 2400/27 - 400 - 3600    // Bx
        },
        'c': {
              '-2': 6 * 2400/27 - 100 - 3600, // Cbb
              '-1': 7 * 2400/27 - 200 - 3600, // Cb
               0: 8 * 2400/27 - 300 - 3600,         // C
               1: 9 * 2400/27 - 400 - 3600,   // C#
               2: 10 * 2400/27 - 500 - 3600    // Cx
        },
        'd': {
              '-2': 10 * 2400/27 - 300 - 3600, // Dbb
              '-1': 11 * 2400/27 - 400 - 3600, // Db
               0: 12 * 2400/27 - 500 - 3600,         // D
               1: 13 * 2400/27 - 600 - 3600,   // D#
               2: 14 * 2400/27 - 700 - 3600    // Dx
        },
        'e': {
              '-2': 14 * 2400/27 - 500 - 3600, // Ebb
              '-1': 15 * 2400/27 - 600 - 3600, // Eb
               0: 16 * 2400/27 - 700 - 3600,         // E
               1: 17 * 2400/27 - 800 - 3600,   // E#
               2: 18 * 2400/27 - 900 - 3600    // Ex
        },
        'f': {
              '-2': 18 * 2400/27 - 600 - 3600, // Fbb
              '-1': 19 * 2400/27 - 700 - 3600, // Fb
               0: 20 * 2400/27 - 800 - 3600,         // F
               1: 21 * 2400/27 - 900 - 3600,   // F#
               2: 22 * 2400/27 - 1000 - 3600    // Fx
        },
        'g': {
              '-2': 21 * 2400/27 - 800 - 3600, // Gbb
              '-1': 22 * 2400/27 - 900 - 3600, // Gb
               0: 23 * 2400/27 - 1000 - 3600,         // G
               1: 24 * 2400/27 - 1100 - 3600,   // G#
               2: 25 * 2400/27 - 1200 - 4800    // Gx correction
        }
        },
          'od2': {
            'a': {
              '-2': 200 - 2 * 2400/27 - 1200, // Abb correction
              '-1': 100 - 1 * 2400/27 - 1200, // Ab correction
               0: 0 - 2400,         // A
               1: 1 * 2400/27 - 100 - 2400,   // A#
               2: 2 * 2400/27 - 200 - 2400    // Ax
            },
            'b': {
                  '-2': 2 * 2400/27 - 2400, // Bbb
                  '-1': 3 * 2400/27 - 100 - 2400, // Bb
                   0: 4 * 2400/27 - 200 - 2400,         // B
                   1: 5 * 2400/27 - 300 - 2400,   // B#
                   2: 6 * 2400/27 - 400 - 2400    // Bx
            },
            'c': {
                  '-2': 6 * 2400/27 - 100 - 2400, // Cbb
                  '-1': 7 * 2400/27 - 200 - 2400, // Cb
                   0: 8 * 2400/27 - 300 - 2400,         // C
                   1: 9 * 2400/27 - 400 - 2400,   // C#
                   2: 10 * 2400/27 - 500 - 2400    // Cx
            },
            'd': {
                  '-2': 10 * 2400/27 - 300 - 2400, // Dbb
                  '-1': 11 * 2400/27 - 400 - 2400, // Db
                   0: 12 * 2400/27 - 500 - 2400,         // D
                   1: 13 * 2400/27 - 600 - 2400,   // D#
                   2: 14 * 2400/27 - 700 - 2400    // Dx
            },
            'e': {
                  '-2': 14 * 2400/27 - 500 - 2400, // Ebb
                  '-1': 15 * 2400/27 - 600 - 2400, // Eb
                   0: 16 * 2400/27 - 700 - 2400,         // E
                   1: 17 * 2400/27 - 800 - 2400,   // E#
                   2: 18 * 2400/27 - 900 - 2400    // Ex
            },
            'f': {
                  '-2': 18 * 2400/27 - 600 - 2400, // Fbb
                  '-1': 19 * 2400/27 - 700 - 2400, // Fb
                   0: 20 * 2400/27 - 800 - 2400,         // F
                   1: 21 * 2400/27 - 900 - 2400,   // F#
                   2: 22 * 2400/27 - 1000 - 2400    // Fx
            },
            'g': {
                  '-2': 21 * 2400/27 - 800 - 2400, // Gbb
                  '-1': 22 * 2400/27 - 900 - 2400, // Gb
                   0: 23 * 2400/27 - 1000 - 2400,         // G
                   1: 24 * 2400/27 - 1100 - 2400,   // G#
                   2: 25 * 2400/27 - 1200 - 3600    // Gx correction
            }
            },
          'od1': {
            'a': {
              '-2': 200 - 2 * 2400/27, // Abb correction
              '-1': 100 - 1 * 2400/27, // Ab correction
               0: 0 - 1200,         // A
               1: 1 * 2400/27 - 100 - 1200,   // A#
               2: 2 * 2400/27 - 200 - 1200    // Ax
            },
            'b': {
                  '-2': 2 * 2400/27 - 1200, // Bbb
                  '-1': 3 * 2400/27 - 100 - 1200, // Bb
                   0: 4 * 2400/27 - 200 - 1200,         // B
                   1: 5 * 2400/27 - 300 - 1200,   // B#
                   2: 6 * 2400/27 - 400 - 1200    // Bx
            },
            'c': {
                  '-2': 6 * 2400/27 - 100 - 1200, // Cbb
                  '-1': 7 * 2400/27 - 200 - 1200, // Cb
                   0: 8 * 2400/27 - 300 - 1200,         // C
                   1: 9 * 2400/27 - 400 - 1200,   // C#
                   2: 10 * 2400/27 - 500 - 1200    // Cx
            },
            'd': {
                  '-2': 10 * 2400/27 - 300 - 1200, // Dbb
                  '-1': 11 * 2400/27 - 400 - 1200, // Db
                   0: 12 * 2400/27 - 500 - 1200,         // D
                   1: 13 * 2400/27 - 600 - 1200,   // D#
                   2: 14 * 2400/27 - 700 - 1200    // Dx
            },
            'e': {
                  '-2': 14 * 2400/27 - 500 - 1200, // Ebb
                  '-1': 15 * 2400/27 - 600 - 1200, // Eb
                   0: 16 * 2400/27 - 700 - 1200,         // E
                   1: 17 * 2400/27 - 800 - 1200,   // E#
                   2: 18 * 2400/27 - 900 - 1200    // Ex
            },
            'f': {
                  '-2': 18 * 2400/27 - 600 - 1200, // Fbb
                  '-1': 19 * 2400/27 - 700 - 1200, // Fb
                   0: 20 * 2400/27 - 800 - 1200,         // F
                   1: 21 * 2400/27 - 900 - 1200,   // F#
                   2: 22 * 2400/27 - 1000 - 1200    // Fx
            },
            'g': {
                  '-2': 21 * 2400/27 - 800 - 1200, // Gbb
                  '-1': 22 * 2400/27 - 900 - 1200, // Gb
                   0: 23 * 2400/27 - 1000 - 1200,         // G
                   1: 24 * 2400/27 - 1100 - 1200,   // G#
                   2: 25 * 2400/27 - 1200 - 2400    // Gx correction
            }
            },
          'ob': {
            'a': {
              '-2': 200 - 2 * 2400/27 + 1200, // Abb correction
              '-1': 100 - 1 * 2400/27 + 1200, // Ab correction
               0: 0,         // A
               1: 1 * 2400/27 - 100,   // A#
               2: 2 * 2400/27 - 200     // Ax
            },
            'b': {
                  '-2': 2 * 2400/27, // Bbb
                  '-1': 3 * 2400/27 - 100, // Bb
                   0: 4 * 2400/27 - 200,         // B
                   1: 5 * 2400/27 - 300,   // B#
                   2: 6 * 2400/27 - 400     // Bx
            },
            'c': {
                  '-2': 6 * 2400/27 - 100, // Cbb
                  '-1': 7 * 2400/27 - 200, // Cb
                   0: 8 * 2400/27 - 300,         // C
                   1: 9 * 2400/27 - 400,   // C#
                   2: 10 * 2400/27 - 500     // Cx
            },
            'd': {
                  '-2': 10 * 2400/27 - 300, // Dbb
                  '-1': 11 * 2400/27 - 400, // Db
                   0: 12 * 2400/27 - 500,         // D
                   1: 13 * 2400/27 - 600,   // D#
                   2: 14 * 2400/27 - 700     // Dx
            },
            'e': {
                  '-2': 14 * 2400/27 - 500, // Ebb
                  '-1': 15 * 2400/27 - 600, // Eb
                   0: 16 * 2400/27 - 700,         // E
                   1: 17 * 2400/27 - 800,   // E#
                   2: 18 * 2400/27 - 900     // Ex
            },
            'f': {
                  '-2': 18 * 2400/27 - 600, // Fbb
                  '-1': 19 * 2400/27 - 700, // Fb
                   0: 20 * 2400/27 - 800,         // F
                   1: 21 * 2400/27 - 900,   // F#
                   2: 22 * 2400/27 - 1000     // Fx
            },
            'g': {
                  '-2': 21 * 2400/27 - 800, // Gbb
                  '-1': 22 * 2400/27 - 900, // Gb
                   0: 23 * 2400/27 - 1000,         // G
                   1: 24 * 2400/27 - 1100,   // G#
                   2: 25 * 2400/27 - 1200 - 1200     // Gx correction
            }
            },
          'ou1': {
            'a': {
              '-2': 200 - 2 * 2400/27 + 2400, // Abb correction
              '-1': 100 - 1 * 2400/27 + 2400, // Ab correction
               0: 0 + 1200,         // A
               1: 1 * 2400/27 - 100 + 1200,   // A#
               2: 2 * 2400/27 - 200 + 1200    // Ax
            },
            'b': {
                  '-2': 2 * 2400/27 + 1200, // Bbb
                  '-1': 3 * 2400/27 - 100 + 1200, // Bb
                   0: 4 * 2400/27 - 200 + 1200,         // B
                   1: 5 * 2400/27 - 300 + 1200,   // B#
                   2: 6 * 2400/27 - 400 + 1200    // Bx
            },
            'c': {
                  '-2': 6 * 2400/27 - 100 + 1200, // Cbb
                  '-1': 7 * 2400/27 - 200 + 1200, // Cb
                   0: 8 * 2400/27 - 300 + 1200,         // C
                   1: 9 * 2400/27 - 400 + 1200,   // C#
                   2: 10 * 2400/27 - 500 + 1200    // Cx
            },
            'd': {
                  '-2': 10 * 2400/27 - 300 + 1200, // Dbb
                  '-1': 11 * 2400/27 - 400 + 1200, // Db
                   0: 12 * 2400/27 - 500 + 1200,         // D
                   1: 13 * 2400/27 - 600 + 1200,   // D#
                   2: 14 * 2400/27 - 700 + 1200    // Dx
            },
            'e': {
                  '-2': 14 * 2400/27 - 500 + 1200, // Ebb
                  '-1': 15 * 2400/27 - 600 + 1200, // Eb
                   0: 16 * 2400/27 - 700 + 1200,         // E
                   1: 17 * 2400/27 - 800 + 1200,   // E#
                   2: 18 * 2400/27 - 900 + 1200    // Ex
            },
            'f': {
                  '-2': 18 * 2400/27 - 600 + 1200, // Fbb
                  '-1': 19 * 2400/27 - 700 + 1200, // Fb
                   0: 20 * 2400/27 - 800 + 1200,         // F
                   1: 21 * 2400/27 - 900 + 1200,   // F#
                   2: 22 * 2400/27 - 1000 + 1200    // Fx
            },
            'g': {
                  '-2': 21 * 2400/27 - 800 + 1200, // Gbb
                  '-1': 22 * 2400/27 - 900 + 1200, // Gb
                   0: 23 * 2400/27 - 1000 + 1200,         // G
                   1: 24 * 2400/27 - 1100 + 1200,   // G#
                   2: 25 * 2400/27 - 1200    // Gx correction
            }
            },
          'ou2': {
            'a': {
              '-2': 200 - 2 * 2400/27 + 3600, // Abb correction
              '-1': 100 - 1 * 2400/27 + 3600, // Ab correction
               0: 0 + 2400,         // A
               1: 1 * 2400/27 - 100 + 2400,   // A#
               2: 2 * 2400/27 - 200 + 2400    // Ax
            },
            'b': {
                  '-2': 2 * 2400/27 + 2400, // Bbb
                  '-1': 3 * 2400/27 - 100 + 2400, // Bb
                   0: 4 * 2400/27 - 200 + 2400,         // B
                   1: 5 * 2400/27 - 300 + 2400,   // B#
                   2: 6 * 2400/27 - 400 + 2400    // Bx
            },
            'c': {
                  '-2': 6 * 2400/27 - 100 + 2400, // Cbb
                  '-1': 7 * 2400/27 - 200 + 2400, // Cb
                   0: 8 * 2400/27 - 300 + 2400,         // C
                   1: 9 * 2400/27 - 400 + 2400,   // C#
                   2: 10 * 2400/27 - 500 + 2400    // Cx
            },
            'd': {
                  '-2': 10 * 2400/27 - 300 + 2400, // Dbb
                  '-1': 11 * 2400/27 - 400 + 2400, // Db
                   0: 12 * 2400/27 - 500 + 2400,         // D
                   1: 13 * 2400/27 - 600 + 2400,   // D#
                   2: 14 * 2400/27 - 700 + 2400    // Dx
            },
            'e': {
                  '-2': 14 * 2400/27 - 500 + 2400, // Ebb
                  '-1': 15 * 2400/27 - 600 + 2400, // Eb
                   0: 16 * 2400/27 - 700 + 2400,         // E
                   1: 17 * 2400/27 - 800 + 2400,   // E#
                   2: 18 * 2400/27 - 900 + 2400    // Ex
            },
            'f': {
                  '-2': 18 * 2400/27 - 600 + 2400, // Fbb
                  '-1': 19 * 2400/27 - 700 + 2400, // Fb
                   0: 20 * 2400/27 - 800 + 2400,         // F
                   1: 21 * 2400/27 - 900 + 2400,   // F#
                   2: 22 * 2400/27 - 1000 + 2400    // Fx
            },
            'g': {
                  '-2': 21 * 2400/27 - 800 + 2400, // Gbb
                  '-1': 22 * 2400/27 - 900 + 2400, // Gb
                   0: 23 * 2400/27 - 1000 + 2400,         // G
                   1: 24 * 2400/27 - 1100 + 2400,   // G#
                   2: 25 * 2400/27 - 1200 + 1200    // Gx correction
            }
            }
      }

      Rectangle {
          color: "white"
          anchors.fill: parent

          Text {
            text: "27ED4 Nelindic retune"
            x: 95
            y: 75
          }


          Button {
            x: 70
            y: 150
            width: 200
            height: 75
            text: "Retune!"
            onClicked: {
              var parms = {};
              parms.keySig = {
                'c': 0,
                'd': 0,
                'e': 0,
                'f': 0,
                'g': 0,
                'a': 0,
                'b': 0,
              };
              parms.currKeySig = parms.keySig

              parms.accidentals = {};

              applyToNotesInSelection(tuneNote, parms);
              (typeof(quit) === 'undefined' ? Qt.quit : quit)();
            }
          }
      }

      function convertAccidentalToSteps(acc) {
        switch(acc.trim()) {
        case 'bb':
          return -2;
        case 'b':
          return -1;
        case '':
          return 0;
        case '#':
          return 1;
        case 'x':
          return 2;
        default:
          return 0;
        }
      }
      function convertAccidentalToStepsOrNull(acc) {
        switch(acc.trim()) {
        case 'bb':
          return -2;
        case 'b':
          return -1;
        case '':
          return 0;
        case '#':
          return 1;
        case 'x':
          return 2;
        default:
          return null;
        }
      }

      // Takes in annotations[].text and returns either
      // a key signature object if str is a valid custom key sig code or null.
      //
      // Valid key sig code is denoted as such:
      //  .c.d.e.f.g.a.b
      // where identifiers c thru b denote a valid accidental code of which
      // will apply to the respective notes.
      //
      // For example, this is F-down major: .v.v.v.v.v.v.bv
      //
      // whitespace can be placed between dots and accidentals for readability.
      //
      // For the natural accidental, blank or whitespace will both work.
      //
      // Assign the key signature object to the parms.currKeySig field!
      function scanCustomKeySig(str) {
          str = str.trim();
          var keySig = {};
          var res = str.match(customKeySigRegex);
          if (res === null)
            return null;
          var acc = convertAccidentalToStepsOrNull(res[1].trim());
          if (acc !== null)
            keySig.c = acc;
          else
            return null;
          acc = convertAccidentalToStepsOrNull(res[2].trim());
          if (acc !== null)
            keySig.d = acc;
          else
            return null;
          acc = convertAccidentalToStepsOrNull(res[3].trim());
          if (acc !== null)
            keySig.e = acc;
          else
            return null;
          acc = convertAccidentalToStepsOrNull(res[4].trim());
          if (acc !== null)
            keySig.f = acc;
          else
            return null;
          acc = convertAccidentalToStepsOrNull(res[5].trim());
          if (acc !== null)
            keySig.g = acc;
          else
            return null;
          acc = convertAccidentalToStepsOrNull(res[6].trim());
          if (acc !== null)
            keySig.a = acc;
          else
            return null;
          acc = convertAccidentalToStepsOrNull(res[7].trim());
          if (acc !== null)
            keySig.b = acc;
          else
            return null;

          return keySig;
      }

      // Apply the given function to all notes in selection
      // or, if nothing is selected, in the entire score

      function applyToNotesInSelection(func, parms) {
        var cursor = curScore.newCursor();
        cursor.rewind(1);
        var startStaff;
        var endStaff;
        var endTick;
        var fullScore = false;
        if (!cursor.segment) { // no selection
          fullScore = true;
          startStaff = 0; // start with 1st staff
          endStaff = curScore.nstaves - 1; // and end with last
        } else {
          startStaff = cursor.staffIdx;
          cursor.rewind(2);
          if (cursor.tick == 0) {
            // this happens when the selection includes
            // the last measure of the score.
            // rewind(2) goes behind the last segment (where
            // there's none) and sets tick=0
            endTick = curScore.lastSegment.tick + 1;
          } else {
            endTick = cursor.tick;
          }
          endStaff = cursor.staffIdx;
        }
        console.log(startStaff + " - " + endStaff + " - " + endTick)
        // -------------- Actual thing here -----------------------


        for (var staff = startStaff; staff <= endStaff; staff++) {
          for (var voice = 0; voice < 4; voice++) {
            cursor.rewind(1); // sets voice to 0
            cursor.voice = voice; //voice has to be set after goTo
            cursor.staffIdx = staff;

            if (fullScore)
              cursor.rewind(0) // if no selection, beginning of score

            var measureCount = 0;

            // After every track/voice, reset the currKeySig back to the original keySig

            parms.currKeySig = parms.keySig;
            console.log("currKeySig reset");

            // Loop elements of a voice
            while (cursor.segment && (fullScore || cursor.tick < endTick)) {
              // Reset accidentals if new measure.
              if (cursor.segment.tick == cursor.measure.firstSegment.tick) {
                parms.accidentals = {};
                measureCount ++;
                console.log("Reset accidentals - " + measureCount);
              }

              /* Check for StaffText key signature changes.
              for (var i = 0, annotation = cursor.segment.annotations[i]; i < cursor.segment.annotations.length; i++) {
                var maybeKeySig = scanCustomKeySig(annotation.text);
                if (maybeKeySig !== null) {
                  parms.currKeySig = maybeKeySig;
                  console.log("detected new customer keySig: " + annotation.text);
                }
              }*/

              if (cursor.element) {

                if (cursor.element.type == Element.CHORD) {
                  var graceChords = cursor.element.graceNotes;
                  for (var i = 0; i < graceChords.length; i++) {
                    // iterate through all grace chords
                    var notes = graceChords[i].notes;
                    for (var j = 0; j < notes.length; j++)
                      func(notes[j], parms);
                  }
                  var notes = cursor.element.notes;
                  for (var i = 0; i < notes.length; i++) {
                    var note = notes[i];
                    func(note, parms);
                  }
                }
              }
              cursor.next();
            }
          }
        }
      }

      function tuneNote(note, parms) {
        var tpc = note.tpc;
        var acc = note.accidental;
        var pitch = note.pitch;

        // If tpc is non-natural, there's no need to go through additional steps,
        // since accidentals and key sig are already taken into consideration
        // to produce a non-screw-up tpc.

        // However, if tpc is natural, it would need to be checked against acc and
        // the key signature, but ti will always be null in this tuning.

        if (pitch >= 33 && pitch <= 44) {

        switch(tpc) {
        case -1: //Fbb
          note.tuning = centOffsets['od3']['f'][-2];
          return;
        case 0: //Cbb
          note.tuning = centOffsets['od3']['c'][-2];
          return;
        case 1: //Gbb
          note.tuning = centOffsets['od3']['g'][-2];
          return;
        case 2: //Dbb
          note.tuning = centOffsets['od3']['d'][-2];
          return;
        case 3: //Abb
          note.tuning = centOffsets['od3']['a'][-2];
          return;
        case 4: //Ebb
          note.tuning = centOffsets['od3']['e'][-2];
          return;
        case 5: //Bbb
          note.tuning = centOffsets['od3']['b'][-2];
          return;

        case 6: //Fb
          note.tuning = centOffsets['od3']['f'][-1];
          return;
        case 7: //Cb
          note.tuning = centOffsets['od3']['c'][-1];
          return;
        case 8: //Gb
          note.tuning = centOffsets['od3']['g'][-1];
          return;
        case 9: //Db
          note.tuning = centOffsets['od3']['d'][-1];
          return;
        case 10: //Ab
          note.tuning = centOffsets['od3']['a'][-1];
          return;
        case 11: //Eb
          note.tuning = centOffsets['od3']['e'][-1];
          return;
        case 12: //Bb
          note.tuning = centOffsets['od3']['b'][-1];
          return;

        case 13: //F
          note.tuning = centOffsets['od3']['f'][0];
          return;
        case 14: //C
          note.tuning = centOffsets['od3']['c'][0];
          return;
        case 15: //G
          note.tuning = centOffsets['od3']['g'][0];
          return;
        case 16: //D
          note.tuning = centOffsets['od3']['d'][0];
          return;
        case 17: //A
          note.tuning = centOffsets['od3']['a'][0];
          return;
        case 18: //E
          note.tuning = centOffsets['od3']['e'][0];
          return;
        case 19: //B
          note.tuning = centOffsets['od3']['b'][0];
          return;

        case 20: //F#
          note.tuning = centOffsets['od3']['f'][1];
          return;
        case 21: //C#
          note.tuning = centOffsets['od3']['c'][1];
          return;
        case 22: //G#
          note.tuning = centOffsets['od3']['g'][1];
          return;
        case 23: //D#
          note.tuning = centOffsets['od3']['d'][1];
          return;
        case 24: //A#
          note.tuning = centOffsets['od3']['a'][1];
          return;
        case 25: //E#
          note.tuning = centOffsets['od3']['e'][1];
          return;
        case 26: //B#
          note.tuning = centOffsets['od3']['b'][1];
          return;

        case 27: //Fx
          note.tuning = centOffsets['od3']['f'][2];
          return;
        case 28: //Cx
          note.tuning = centOffsets['od3']['c'][2];
          return;
        case 29: //Gx
          note.tuning = centOffsets['od3']['g'][2];
          return;
        case 30: //Dx
          note.tuning = centOffsets['od3']['d'][2];
          return;
        case 31: //Ax
          note.tuning = centOffsets['od3']['a'][2];
          return;
        case 32: //Ex
          note.tuning = centOffsets['od3']['e'][2];
          return;
        case 33: //Bx
          note.tuning = centOffsets['od3']['b'][2];
          return;
        };
};
        if (pitch >= 45 && pitch <= 56) {

      switch(tpc) {
      case -1: //Fbb
        note.tuning = centOffsets['od2']['f'][-2];
        return;
      case 0: //Cbb
        note.tuning = centOffsets['od2']['c'][-2];
        return;
      case 1: //Gbb
        note.tuning = centOffsets['od2']['g'][-2];
        return;
      case 2: //Dbb
        note.tuning = centOffsets['od2']['d'][-2];
        return;
      case 3: //Abb
        note.tuning = centOffsets['od2']['a'][-2];
        return;
      case 4: //Ebb
        note.tuning = centOffsets['od2']['e'][-2];
        return;
      case 5: //Bbb
        note.tuning = centOffsets['od2']['b'][-2];
        return;

      case 6: //Fb
        note.tuning = centOffsets['od2']['f'][-1];
        return;
      case 7: //Cb
        note.tuning = centOffsets['od2']['c'][-1];
        return;
      case 8: //Gb
        note.tuning = centOffsets['od2']['g'][-1];
        return;
      case 9: //Db
        note.tuning = centOffsets['od2']['d'][-1];
        return;
      case 10: //Ab
        note.tuning = centOffsets['od2']['a'][-1];
        return;
      case 11: //Eb
        note.tuning = centOffsets['od2']['e'][-1];
        return;
      case 12: //Bb
        note.tuning = centOffsets['od2']['b'][-1];
        return;

      case 13: //F
        note.tuning = centOffsets['od2']['f'][0];
        return;
      case 14: //C
        note.tuning = centOffsets['od2']['c'][0];
        return;
      case 15: //G
        note.tuning = centOffsets['od2']['g'][0];
        return;
      case 16: //D
        note.tuning = centOffsets['od2']['d'][0];
        return;
      case 17: //A
        note.tuning = centOffsets['od2']['a'][0];
        return;
      case 18: //E
        note.tuning = centOffsets['od2']['e'][0];
        return;
      case 19: //B
        note.tuning = centOffsets['od2']['b'][0];
        return;

      case 20: //F#
        note.tuning = centOffsets['od2']['f'][1];
        return;
      case 21: //C#
        note.tuning = centOffsets['od2']['c'][1];
        return;
      case 22: //G#
        note.tuning = centOffsets['od2']['g'][1];
        return;
      case 23: //D#
        note.tuning = centOffsets['od2']['d'][1];
        return;
      case 24: //A#
        note.tuning = centOffsets['od2']['a'][1];
        return;
      case 25: //E#
        note.tuning = centOffsets['od2']['e'][1];
        return;
      case 26: //B#
        note.tuning = centOffsets['od2']['b'][1];
        return;

      case 27: //Fx
        note.tuning = centOffsets['od2']['f'][2];
        return;
      case 28: //Cx
        note.tuning = centOffsets['od2']['c'][2];
        return;
      case 29: //Gx
        note.tuning = centOffsets['od2']['g'][2];
        return;
      case 30: //Dx
        note.tuning = centOffsets['od2']['d'][2];
        return;
      case 31: //Ax
        note.tuning = centOffsets['od2']['a'][2];
        return;
      case 32: //Ex
        note.tuning = centOffsets['od2']['e'][2];
        return;
      case 33: //Bx
        note.tuning = centOffsets['od2']['b'][2];
        return;
      };
};
        if (pitch >= 57 && pitch <= 68) {

        switch(tpc) {
        case -1: //Fbb
          note.tuning = centOffsets['od1']['f'][-2];
          return;
        case 0: //Cbb
          note.tuning = centOffsets['od1']['c'][-2];
          return;
        case 1: //Gbb
          note.tuning = centOffsets['od1']['g'][-2];
          return;
        case 2: //Dbb
          note.tuning = centOffsets['od1']['d'][-2];
          return;
        case 3: //Abb
          note.tuning = centOffsets['od1']['a'][-2];
          return;
        case 4: //Ebb
          note.tuning = centOffsets['od1']['e'][-2];
          return;
        case 5: //Bbb
          note.tuning = centOffsets['od1']['b'][-2];
          return;

        case 6: //Fb
          note.tuning = centOffsets['od1']['f'][-1];
          return;
        case 7: //Cb
          note.tuning = centOffsets['od1']['c'][-1];
          return;
        case 8: //Gb
          note.tuning = centOffsets['od1']['g'][-1];
          return;
        case 9: //Db
          note.tuning = centOffsets['od1']['d'][-1];
          return;
        case 10: //Ab
          note.tuning = centOffsets['od1']['a'][-1];
          return;
        case 11: //Eb
          note.tuning = centOffsets['od1']['e'][-1];
          return;
        case 12: //Bb
          note.tuning = centOffsets['od1']['b'][-1];
          return;

        case 13: //F
          note.tuning = centOffsets['od1']['f'][0];
          return;
        case 14: //C
          note.tuning = centOffsets['od1']['c'][0];
          return;
        case 15: //G
          note.tuning = centOffsets['od1']['g'][0];
          return;
        case 16: //D
          note.tuning = centOffsets['od1']['d'][0];
          return;
        case 17: //A
          note.tuning = centOffsets['od1']['a'][0];
          return;
        case 18: //E
          note.tuning = centOffsets['od1']['e'][0];
          return;
        case 19: //B
          note.tuning = centOffsets['od1']['b'][0];
          return;

        case 20: //F#
          note.tuning = centOffsets['od1']['f'][1];
          return;
        case 21: //C#
          note.tuning = centOffsets['od1']['c'][1];
          return;
        case 22: //G#
          note.tuning = centOffsets['od1']['g'][1];
          return;
        case 23: //D#
          note.tuning = centOffsets['od1']['d'][1];
          return;
        case 24: //A#
          note.tuning = centOffsets['od1']['a'][1];
          return;
        case 25: //E#
          note.tuning = centOffsets['od1']['e'][1];
          return;
        case 26: //B#
          note.tuning = centOffsets['od1']['b'][1];
          return;

        case 27: //Fx
          note.tuning = centOffsets['od1']['f'][2];
          return;
        case 28: //Cx
          note.tuning = centOffsets['od1']['c'][2];
          return;
        case 29: //Gx
          note.tuning = centOffsets['od1']['g'][2];
          return;
        case 30: //Dx
          note.tuning = centOffsets['od1']['d'][2];
          return;
        case 31: //Ax
          note.tuning = centOffsets['od1']['a'][2];
          return;
        case 32: //Ex
          note.tuning = centOffsets['od1']['e'][2];
          return;
        case 33: //Bx
          note.tuning = centOffsets['od1']['b'][2];
          return;
        };
};
        if (pitch >= 81 && pitch <= 92) {

            switch(tpc) {
            case -1: //Fbb
              note.tuning = centOffsets['ou1']['f'][-2];
              return;
            case 0: //Cbb
              note.tuning = centOffsets['ou1']['c'][-2];
              return;
            case 1: //Gbb
              note.tuning = centOffsets['ou1']['g'][-2];
              return;
            case 2: //Dbb
              note.tuning = centOffsets['ou1']['d'][-2];
              return;
            case 3: //Abb
              note.tuning = centOffsets['ou1']['a'][-2];
              return;
            case 4: //Ebb
              note.tuning = centOffsets['ou1']['e'][-2];
              return;
            case 5: //Bbb
              note.tuning = centOffsets['ou1']['b'][-2];
              return;

            case 6: //Fb
              note.tuning = centOffsets['ou1']['f'][-1];
              return;
            case 7: //Cb
              note.tuning = centOffsets['ou1']['c'][-1];
              return;
            case 8: //Gb
              note.tuning = centOffsets['ou1']['g'][-1];
              return;
            case 9: //Db
              note.tuning = centOffsets['ou1']['d'][-1];
              return;
            case 10: //Ab
              note.tuning = centOffsets['ou1']['a'][-1];
              return;
            case 11: //Eb
              note.tuning = centOffsets['ou1']['e'][-1];
              return;
            case 12: //Bb
              note.tuning = centOffsets['ou1']['b'][-1];
              return;

            case 13: //F
              note.tuning = centOffsets['ou1']['f'][0];
              return;
            case 14: //C
              note.tuning = centOffsets['ou1']['c'][0];
              return;
            case 15: //G
              note.tuning = centOffsets['ou1']['g'][0];
              return;
            case 16: //D
              note.tuning = centOffsets['ou1']['d'][0];
              return;
            case 17: //A
              note.tuning = centOffsets['ou1']['a'][0];
              return;
            case 18: //E
              note.tuning = centOffsets['ou1']['e'][0];
              return;
            case 19: //B
              note.tuning = centOffsets['ou1']['b'][0];
              return;

            case 20: //F#
              note.tuning = centOffsets['ou1']['f'][1];
              return;
            case 21: //C#
              note.tuning = centOffsets['ou1']['c'][1];
              return;
            case 22: //G#
              note.tuning = centOffsets['ou1']['g'][1];
              return;
            case 23: //D#
              note.tuning = centOffsets['ou1']['d'][1];
              return;
            case 24: //A#
              note.tuning = centOffsets['ou1']['a'][1];
              return;
            case 25: //E#
              note.tuning = centOffsets['ou1']['e'][1];
              return;
            case 26: //B#
              note.tuning = centOffsets['ou1']['b'][1];
              return;

            case 27: //Fx
              note.tuning = centOffsets['ou1']['f'][2];
              return;
            case 28: //Cx
              note.tuning = centOffsets['ou1']['c'][2];
              return;
            case 29: //Gx
              note.tuning = centOffsets['ou1']['g'][2];
              return;
            case 30: //Dx
              note.tuning = centOffsets['ou1']['d'][2];
              return;
            case 31: //Ax
              note.tuning = centOffsets['ou1']['a'][2];
              return;
            case 32: //Ex
              note.tuning = centOffsets['ou1']['e'][2];
              return;
            case 33: //Bx
              note.tuning = centOffsets['ou1']['b'][2];
              return;
            };
};
        if (pitch >= 93 && pitch <= 104) {
            switch(tpc) {
            case -1: //Fbb
              note.tuning = centOffsets['ou2']['f'][-2];
              return;
            case 0: //Cbb
              note.tuning = centOffsets['ou2']['c'][-2];
              return;
            case 1: //Gbb
              note.tuning = centOffsets['ou2']['g'][-2];
              return;
            case 2: //Dbb
              note.tuning = centOffsets['ou2']['d'][-2];
              return;
            case 3: //Abb
              note.tuning = centOffsets['ou2']['a'][-2];
              return;
            case 4: //Ebb
              note.tuning = centOffsets['ou2']['e'][-2];
              return;
            case 5: //Bbb
              note.tuning = centOffsets['ou2']['b'][-2];
              return;

            case 6: //Fb
              note.tuning = centOffsets['ou2']['f'][-1];
              return;
            case 7: //Cb
              note.tuning = centOffsets['ou2']['c'][-1];
              return;
            case 8: //Gb
              note.tuning = centOffsets['ou2']['g'][-1];
              return;
            case 9: //Db
              note.tuning = centOffsets['ou2']['d'][-1];
              return;
            case 10: //Ab
              note.tuning = centOffsets['ou2']['a'][-1];
              return;
            case 11: //Eb
              note.tuning = centOffsets['ou2']['e'][-1];
              return;
            case 12: //Bb
              note.tuning = centOffsets['ou2']['b'][-1];
              return;

            case 13: //F
              note.tuning = centOffsets['ou2']['f'][0];
              return;
            case 14: //C
              note.tuning = centOffsets['ou2']['c'][0];
              return;
            case 15: //G
              note.tuning = centOffsets['ou2']['g'][0];
              return;
            case 16: //D
              note.tuning = centOffsets['ou2']['d'][0];
              return;
            case 17: //A
              note.tuning = centOffsets['ou2']['a'][0];
              return;
            case 18: //E
              note.tuning = centOffsets['ou2']['e'][0];
              return;
            case 19: //B
              note.tuning = centOffsets['ou2']['b'][0];
              return;

            case 20: //F#
              note.tuning = centOffsets['ou2']['f'][1];
              return;
            case 21: //C#
              note.tuning = centOffsets['ou2']['c'][1];
              return;
            case 22: //G#
              note.tuning = centOffsets['ou2']['g'][1];
              return;
            case 23: //D#
              note.tuning = centOffsets['ou2']['d'][1];
              return;
            case 24: //A#
              note.tuning = centOffsets['ou2']['a'][1];
              return;
            case 25: //E#
              note.tuning = centOffsets['ou2']['e'][1];
              return;
            case 26: //B#
              note.tuning = centOffsets['ou2']['b'][1];
              return;

            case 27: //Fx
              note.tuning = centOffsets['ou2']['f'][2];
              return;
            case 28: //Cx
              note.tuning = centOffsets['ou2']['c'][2];
              return;
            case 29: //Gx
              note.tuning = centOffsets['ou2']['g'][2];
              return;
            case 30: //Dx
              note.tuning = centOffsets['ou2']['d'][2];
              return;
            case 31: //Ax
              note.tuning = centOffsets['ou2']['a'][2];
              return;
            case 32: //Ex
              note.tuning = centOffsets['ou2']['e'][2];
              return;
            case 33: //Bx
              note.tuning = centOffsets['ou2']['b'][2];
              return;
            };
};
        if (pitch >= 69 && pitch <= 80) {

            switch(tpc) {
            case -1: //Fbb
              note.tuning = centOffsets['ob']['f'][-2];
              return;
            case 0: //Cbb
              note.tuning = centOffsets['ob']['c'][-2];
              return;
            case 1: //Gbb
              note.tuning = centOffsets['ob']['g'][-2];
              return;
            case 2: //Dbb
              note.tuning = centOffsets['ob']['d'][-2];
              return;
            case 3: //Abb
              note.tuning = centOffsets['ob']['a'][-2];
              return;
            case 4: //Ebb
              note.tuning = centOffsets['ob']['e'][-2];
              return;
            case 5: //Bbb
              note.tuning = centOffsets['ob']['b'][-2];
              return;

            case 6: //Fb
              note.tuning = centOffsets['ob']['f'][-1];
              return;
            case 7: //Cb
              note.tuning = centOffsets['ob']['c'][-1];
              return;
            case 8: //Gb
              note.tuning = centOffsets['ob']['g'][-1];
              return;
            case 9: //Db
              note.tuning = centOffsets['ob']['d'][-1];
              return;
            case 10: //Ab
              note.tuning = centOffsets['ob']['a'][-1];
              return;
            case 11: //Eb
              note.tuning = centOffsets['ob']['e'][-1];
              return;
            case 12: //Bb
              note.tuning = centOffsets['ob']['b'][-1];
              return;

            case 13: //F
              note.tuning = centOffsets['ob']['f'][0];
              return;
            case 14: //C
              note.tuning = centOffsets['ob']['c'][0];
              return;
            case 15: //G
              note.tuning = centOffsets['ob']['g'][0];
              return;
            case 16: //D
              note.tuning = centOffsets['ob']['d'][0];
              return;
            case 17: //A
              note.tuning = centOffsets['ob']['a'][0];
              return;
            case 18: //E
              note.tuning = centOffsets['ob']['e'][0];
              return;
            case 19: //B
              note.tuning = centOffsets['ob']['b'][0];
              return;

            case 20: //F#
              note.tuning = centOffsets['ob']['f'][1];
              return;
            case 21: //C#
              note.tuning = centOffsets['ob']['c'][1];
              return;
            case 22: //G#
              note.tuning = centOffsets['ob']['g'][1];
              return;
            case 23: //D#
              note.tuning = centOffsets['ob']['d'][1];
              return;
            case 24: //A#
              note.tuning = centOffsets['ob']['a'][1];
              return;
            case 25: //E#
              note.tuning = centOffsets['ob']['e'][1];
              return;
            case 26: //B#
              note.tuning = centOffsets['ob']['b'][1];
              return;

            case 27: //Fx
              note.tuning = centOffsets['ob']['f'][2];
              return;
            case 28: //Cx
              note.tuning = centOffsets['ob']['c'][2];
              return;
            case 29: //Gx
              note.tuning = centOffsets['ob']['g'][2];
              return;
            case 30: //Dx
              note.tuning = centOffsets['ob']['d'][2];
              return;
            case 31: //Ax
              note.tuning = centOffsets['ob']['a'][2];
              return;
            case 32: //Ex
              note.tuning = centOffsets['ob']['e'][2];
              return;
            case 33: //Bx
              note.tuning = centOffsets['ob']['b'][2];
              return;
            };
};
      }

      Component.onCompleted: {
        if (mscoreMajorVersion >= 4) {
            title = qsTr("27ed4 Nelindic")
	    thumbnailName = "XenRetune27ed4.png"
            categoryCode = "playback"
        }
    }

      onRun: {
        console.log("hello 27ed4 nelindic");

        if (typeof curScore === 'undefined')
              (typeof(quit) === 'undefined' ? Qt.quit : quit)();
      }
}
